####################
# ## PARAMETERS ## #
####################

config = {
  # paths for connecting to cloud storage
  "vm_path": 'ebm-life-cycle/',
  "gs_path": 'gen-tfrc-uscentral1',
  "exp_name": 'nonconv_sngan',
  "exp_dir": 'tfrc_out/cifar10',

  # device type ('tpu' or 'gpu' or 'cpu')
  "device_type": 'tpu',
  # number of gpus if using gpu device
  #num_gpus: 1,

  # experiment info
  "num_training_steps": 1000000,
  "batch_size": 128,
  "image_dims": [32, 32, 3],

  # data type and augmentation parameters
  "data_type": 'cifar10',
  "data_epsilon": 1e-2,

  # ebm network
  "net_type": 'ebm_sngan',

  # learning rate for ebm
  "ebm_optim_type": 'adam',
  "ebm_lr_info": [[1e-4, 0]],
  "ebm_opt_decay": 0.9999,
  "ebm_lr_type": 'step',

  # langevin sampling parameters
  "epsilon": 5e-3,
  "mcmc_step_info": [[100, 0, 0.5, 0]],
  "mcmc_init": "coop_persistent",
  "mcmc_temp": 1e-4,
  "max_mcmc_updates": 2,

  # persistent image bank parameters
  "persistent_size": 10000,

  # generator network parameters
  "gen_type": "gen_sngan",
  "z_sz": 128,
  "gen_kl_factor": 0,

  # learning rate for gen
  "gen_optim_type": 'adam',
  "gen_lr_info": [[1e-4, 0]],
  "gen_opt_decay": 0.9999,
  "update_generator": True,
  "gen_batch_norm": True,

  # gradient clipping
  "max_grad_norm": 20.0,
  "clip_ebm_grad": True,
  "clip_gen_grad": True,
  "max_langevin_norm": 0.1,
  "clip_langevin_grad": True,

  # logging parameters
  "info_freq": 500,
  "log_freq": 5000,
  "save_networks": True,
  "save_to_cloud": True,

  # longrun parameters
  "log_longrun": False,
  "longrun_freq": 25000,
  "mcmc_steps_longrun": 100000
}
